<?php
require('allinclude.php');

global $user;
if(!$user->checkUserLogged()){//Utilisateur pas connecté
	header('Location: index.php');
}

switch ($_POST['action']) {	
	case 'saveRatios':
		saveRatios();
		break;
		
	case 'setVolume':
		setVolume();
		break;
		
	case 'nextSong':
		nextSong();
		break;
		
	case 'saveConfig':
		saveConfig();
		break;
		
	case 'playStream':
		playStream();
		break;
		
	case 'addStream':
		addStream();
		break;
		
	case 'updatePass':
		updatePass();
		break;
	default:		
		break;
}
function updatePass(){
	global $user;
	$post = $_POST;
	
	$newPass = htmlentities($post['newPass']);
	$oldPass = htmlentities($post['oldPass']);	
	
	$retour = array(
		'status' => 'ok',
		'message' => '',
	);
	
	if(!checkPasswordValidity($newPass)){
		$retour['status'] = 'error';
		$retour['message'] = 'invalid password';
		print json_encode($retour);
		return;
	}
	
	$passState = $user->changePassword($newPass, $oldPass);
	if($passState !== true){
		$retour['status'] = 'error';
		switch($retour){
			case User::RETURN_WRONG_OLD:
				$retour['message'] = "wrong old pass";
				break;
			default : 
				$retour['message'] = "unknow error";
				break;
		}
	}

	print json_encode($retour);
}
function checkPasswordValidity($pass){
	if(strlen($pass) < 12)return false;
	if(!hasLowerCase($pass)) return false;
	if(!hasUpperCase($pass)) return false;
	if(!hasDigit($pass)) return false;
	
	return true;
}

function hasLowerCase($pass) {
    return strtoupper($pass) != $pass;
}

function hasUpperCase($pass) {
    return strtolower($pass) != $pass;
}

function hasDigit($pass){
	return preg_match('~[0-9]+~', $pass);
}
function nextSong(){
	global $mpd;
	$playlist = $mpd->playlist();
	$currentSong = null;
	if(count($playlist) >1){
		$currentSongArray = $mpd->current_song();
		$currentSong = new Song($currentSongArray[0]);
	}
	if(count($playlist) < 2){
		//playlist vide ou pas de prochain titre
		$endOfDay = strtotime("tomorrow Europe/Paris");
		$playlist = Playlist::getInstance();
		$playlist->generate($endOfDay,$cron);
		$playlist->clearAndPlayOnMPD();
	}else{
		$mpd->next();		
	}
	if($currentSong != null){
		$titleParts = explode("/", $currentSong->name);
		$cat = $titleParts[0];
		if($cat == "JINGLES"){ //les jingles on les blacklist pas
			print 'ok';
			return;
		} 
		error_log($cat);
		$blacklist = new Blacklist($currentSong->basename, $currentSong->id);
		BlacklistManager::addBlacklist($blacklist);
	}
	print 'ok';
}

function addStream(){	
	$file_name = $_FILES['field_image']['name'];
	$file_size =$_FILES['field_image']['size'];
	$file_tmp =$_FILES['field_image']['tmp_name'];
	$file_type=$_FILES['field_image']['type'];
	$file_info = explode('.',$_FILES['field_image']['name']);
	$file_ext=strtolower(end($file_info));
	
	$imagedata = file_get_contents($file_tmp);
	$b64Image = base64_encode($imagedata);
	
	$sm = new StreamManager();
	$retour = StreamManager::addStream(
		$_POST["field_name"], 
		$_POST["field_url"], 
		$b64Image, 
		$file_ext);
	print $retour;
}

function playStream(){
	global $mpd;
	$streamManager = new StreamManager();
	
	$fid = $_POST['fid'];	
	$stream = $streamManager->getStreamById($fid);
	$mpd->playlist_clear();		
	$mpd->playlist_add($stream->url);
	$mpd->play(0);
	print 'ok';
}

function saveRatios(){
	$cats = CategoryManager::getInstance();
	if(areAllRatiosTo0($_POST['ratios'])){
		print "all0";
		return;
	}
	foreach ($_POST['ratios'] as $id => $ratio) {
		//$cat = $cats->getCatById($id);
		$cats->categories[$id]->setRatio($ratio);
	}
	$cats->saveRatioChanges();
	print 'ok';
}

function areAllRatiosTo0($ratios){
	foreach ($ratios as $id => $ratio) {
		if($ratio>0)return false;	
	}
	return true;
}

function setVolume(){
	global $mpd;
	$volume = $_POST['volume'];	
	$mpd->setvol($volume);
	print 'ok';
}

function saveConfig(){
	$config = Config::getInstance();
	$config->jingleSpace = $_POST['jingleGap'];
	$config->save();
	
	print 'ok';
}
