<?php
class Config{
	public $jingleSpace = 2;
	public $serialNumber = false;
	public $localIp = false;
	public $version = false;
	private static $file = "minibox.config";
	
	public static function getInstance(){
		$fileContent = file_get_contents(Config::$file);
		if($fileContent) $instance = unserialize(file_get_contents(Config::$file));
		else $instance = new Config();
		
		$instance->serialNumber = $instance->getSerialNumber();
		$instance->localIp = $instance->getLocalIp();
		$instance->version = $instance->getVersion();
		
		return $instance;
	}
	
	private function getSerialNumber(){
		$shellOutput = shell_exec('cat /proc/cpuinfo');
		$lines = explode("\n", $shellOutput);
		
		foreach ($lines as $line) {
			if(substr($line, 0,6) == 'Serial'){
				$serial = substr($line, 10);
				return $serial;
			} 
		}
		
		return false;
	}
	
	private function getLocalIp(){
		$exec = exec("hostname -I"); //the "hostname" is a valid command in both windows and linux
		$ips = trim($exec);
		
		$ips = explode(' ', $ips); //LE retour de la commande hostname-I peut retourner plusieurs ip (v4 et v6) on ne veut que la première ipv4
		foreach ($ips as $ip) {
			$tmp = explode('.', $ip); //une ipv4 a 4 éléments séparés par des .
			if(count($tmp) == 4) return $ip;
		}
		
		return $ips[0]; //SI on a pas trouvé d'ipV4 on retourne la première ip de la commande
	}
	
	private function getVersion(){
		return file_get_contents("version");
	}
	
	public function save(){
		file_put_contents(Config::$file, serialize($this));
	}
	
	public function miniboxTouch(){
		$url = "https://minibox.rtsfm.com/apiv2/miniboxTouch/%s/%s/%s";
		$url = sprintf($url,
			$this->serialNumber,
			$this->localIp,
			$this->version
		);
		file_get_contents($url);
	}
	
	public function __construct(){

	}
}
