<?php

class BlacklistManager{
	private static $instance=null;
	public $blacklist = array();
	private static $webserviceUrl = "https://minibox.rtsfm.com/apiv2/titleBlacklist";
	
	public static function getInstance(){
		if(BlacklistManager::$instance == null){
			BlacklistManager::$instance = new BlacklistManager();
		}
		return BlacklistManager::$instance;
	}
	
	private function __construct(){
		$this->blacklist = $this->getBlacklistedSongs();
	}
	
	public static function addBlacklist($blacklist){
		$config = Config::getInstance();
		
		$datas = array(
			"title" => substr($blacklist->title ,0 ,-4),
			"id" => $blacklist->id,
		);
		return Post::send(BlacklistManager::$webserviceUrl,$config->serialNumber,json_encode($datas));
	}
	
	private function getBlacklistedSongs(){
		$retour = array();
		$config = Config::getInstance();
		$json_blacklist = file_get_contents(BlacklistManager::$webserviceUrl."?serial=".$config->serialNumber);
		$blacklistList = json_decode($json_blacklist,true);
		foreach ($blacklistList as $blacklistSong) {
			$blacklist = new BlackList($blacklistSong['title'], $blacklistSong['id']);
			$retour[] = $blacklist;
		}
		return $retour;
	}
	
	public function isSongInBlacklist($song){
		foreach ($this->blacklist as $blacklist) {
			if($song->id == $blacklist->id){
				return true;
			}
		}
		return false;
	}
}
