<?php
class Category{
	public $name;
	public $basename;
	public $last_modified;
	public $ratio;
	public $id;
	public $hidden = false;
	public $songs = array();
	public $subCats = array();
	
	public function __construct($mpdArray){		
		$this->name = $mpdArray['name'];
		$this->basename = $mpdArray['basename'];
		$this->last_modified = $mpdArray['Last-Modified'];
		$this->loadSongs();
		$this->loadSubCats();
		$this->ratio = Ratios::getInstance()->getRatio($this->name);
		$this->id = sha1($this->name);
		
		$hiddenCat = array('JINGLES','#recycle','@eaDir');
		if(in_array($this->name, $hiddenCat)){
			$this->hidden = true;
		}
	}
	
	public function filterBlacklistedSongs(){
		if($this->name == "JINGLES") return;
		foreach ($this->songs as $key => $song) {
			$blacklisted = BlacklistManager::getInstance()->isSongInBlacklist($song);
			if($blacklisted){
				unset($this->songs[$key]);
			}
		}
		foreach ($this->subCats as $subCat) {
			$subCat->filterBlacklistedSongs();
		}
	}
	
	public function setRatio($ratio){
		$this->ratio = $ratio;
		Ratios::getInstance()->setRatio($this->name,$ratio);
		
	}
	
	public function getCatByName($name){
		foreach($this->subCats as $cat){
			if($cat->basename == $name) return $cat;
		}
		
		return false;
	}
	
	public function resetAllSongUsage(){
		foreach ($this->songs as $song) {
			$song->resetSongUsage();
		}		
	}
	
	public function getUnusedSongs(){
		$retour = array();
		foreach ($this->songs as $song) {
			if($song->usedInPlaylist == false){
				$retour[]=$song;
			}
		}
		
		//si toutes les musiques ont été utilisées, on reset tout
		if(count($retour)==0){
			$this->resetAllSongUsage();
			return $this->getUnusedSongs();
		}else{
			return $retour;
		}
	}
	
	public function pickRandomSong(){
		if(count($this->songs)==0)return null;
		$unusedSongs = $this->getUnusedSongs();		
		$pickedIndex = mt_rand(0,count($unusedSongs)-1);
		
		$pickedSong = $unusedSongs[$pickedIndex];
		$pickedSong->useIt();
		return $pickedSong;
	}
	
	private function loadSongs(){
		global $mpd;
		$mpdChilds = $mpd->dir_list($this->name);
		foreach ($mpdChilds as $mpdChild) {
			if($mpdChild['type'] != 'file') continue;
			$this->songs[] = new Song($mpdChild);
		}
	}
	
	private function loadSubCats(){
		global $mpd;
		$mpdChilds = $mpd->dir_list($this->name);
		foreach ($mpdChilds as $mpdChild) {
			if($mpdChild['type'] != 'directory') continue;
			$this->subCats[] = new Category($mpdChild);
		}
	}
}
