<?php

class CategoryManager{
	private static $instance;
	public $categories;
	
	public static function getInstance(){
		if(CategoryManager::$instance == null) CategoryManager::$instance = new CategoryManager();
		return CategoryManager::$instance;
	}
	
	private function __construct(){
		$this->loadCategories();
	}
	
	private function loadCategories(){
		global $mpd;
		$mpdCats = $mpd->dir_list();
		foreach ($mpdCats as $mpdCat) {
			if($mpdCat['type'] != 'directory') continue;			
			$tmpCat = new Category($mpdCat);
			$this->categories[$tmpCat->id] = $tmpCat;
		}
		
		$this->filterBlacklistedSongs();
	}
	
	public function filterBlacklistedSongs(){
		foreach ($this->categories as $cat) {
			$cat->filterBlacklistedSongs();
		}
	}
	
	public function getIds(){
		return array_keys($this->categories);
	}
	
	public function getCatById($id){
		foreach($this->categories as $cat){
			if($cat->id == $id) return $cat;
		}
		
		return $false;
	}
	
	public function getCatByName($name){
		foreach($this->categories as $cat){
			if($cat->basename == $name) return $cat;
		}
		return false;
	}
	
	public function saveRatioChanges(){
		Ratios::getInstance()->saveRatios();
	}
	
	public function categoryRandomPickWeighted(){
		$rand = mt_rand(1, $this->sumOfRatios());
		
		foreach ($this->categories as $category) {
			$rand -= $category->ratio;
			if($rand <= 0){
				return $category;
			}
		}
	}
	
	public function sumOfRatios(){
		$retour = 0;
		foreach ($this->categories as $category) {
			$retour += $category->ratio;
		}
		return $retour;
	}
	
	public function getCatsWithoutSongs(){
		$categories = $this->categories;
		foreach ($categories as $category) {
			unset($category->songs);
			unset($category->subCats);
		}
		return $categories;
	}
}
