<?php

class Playlist{
	private static $instance;
	public $songs;
	public $time=0;
	
	public static function getInstance(){
		if(Playlist::$instance == null) Playlist::$instance = new Playlist();
		return Playlist::$instance;
	}
	
	private function __construct(){
		
	}
	
	public function generate($until,$display=false){
		$config = Config::getInstance();
		ini_set("memory_limit","-1");
		$cats = CategoryManager::getInstance();
		
		$current = time();
		$i=0;
		while($current+$this->time < $until){
			if($i%$config->jingleSpace == 0){
				$song = $this->pickJingle();
				$this->songs[] = $song;
				$this->time += $song->time;
				if($display)print date('d/m/Y H:i:s',$current+$this->time).' | '.$song->name."\n";
			}
			$pickedCat = $cats->categoryRandomPickWeighted();
			$pickedSong = $pickedCat->pickRandomSong();
			
			//Si ya pas de musique dans la catégorie
			if($pickedSong == null){
				$pickedCat->ratio = 0;
				continue;
			}
			
			$this->songs[] = $pickedSong;
			$this->time += $pickedSong->time;
			if($display)print date('d/m/Y H:i:s',$current+$this->time).' | '.$pickedSong->name."\n";
			$i++;
		}
		return $this->songs;
	}
	
	public function pickJingle(){
		$cats = CategoryManager::getInstance();
		$config = Config::getInstance();
		
		$jingleCat = $cats->getCatByName('JINGLES');
		
		$miniboxCat = null;
		if($jingleCat == null) return null;
		if($config->serialNumber != false){
			$miniboxCat = $jingleCat->getCatByName($config->serialNumber);
		}
		
		if(!$miniboxCat || count($miniboxCat->songs) == 0){
			$miniboxCat = $jingleCat->getCatByName('COMMUNS');
		}
		
		if(!$miniboxCat) return null; //Catégorie introuvable
		return $miniboxCat->pickRandomSong();		
	}
	
	public function clearAndPlayOnMPD(){
		global $mpd;
		$mpd->playlist_clear();
		foreach ($this->songs as $song) {
			$mpd->playlist_add($song->name);
		}
		$mpd->play(0);
	}
	
	public function getSongList(){
		$retour = array();
		foreach ($this->songs as $song) {
			$retour[] = $song->name;
		}
		return $retour;
	}
	
	public function getSongListText(){
		$current = time();
		$retour = array();
		foreach ($this->songs as $song) {
			$retour[] = date('d/m/Y H:i:s',$current).' | '.$song->name;
			$current+=$song->time;
		}
		$retour[]="FIN A ".date('d/m/Y H:i:s',$current);
		return $retour;
	}
}
