<?php

class StreamManager{
	public $streams;
	private $config;
	private static $webserviceUrl = "https://minibox.rtsfm.com/apiv2/stream";
	
	public function __construct(){
		$this->getStream();
	}
	
	public function getStreamById($id){
		foreach ($this->streams as $stream) {
			if($id == $stream->fid) return $stream;
		}
		return false;
	}
	
	public function getStream(){		
		$this->config = Config::getInstance();
		$streams_json = file_get_contents(StreamManager::$webserviceUrl."?serial=".$this->config->serialNumber);
		$streams = json_decode($streams_json);
		foreach ($streams as $stream) {
			$tmpStream = new Stream();
			$tmpStream->fid = $stream->fid;
			$tmpStream->name = $stream->name;
			$tmpStream->url = $stream->url;
			$tmpStream->image = $stream->image;
			
			$this->streams[] = $tmpStream;
		}
	}
	
	public static function addStream($name, $url, $b64Image, $imageExtension){
		$config = Config::getInstance();
		
		$datas = array(
			"name" => $name,
			"url" => $url,
			"image" => $b64Image,
			"image_extension" => $imageExtension
		);
		return Post::send(StreamManager::$webserviceUrl,$config->serialNumber,json_encode($datas));
	}
}
