<?php

class User{
	private $passFile = "pass.rts";
	private $storedHash = "";
	
	private $masterPassFile = "masterpass.rts";
	private $masterStoredHash = "";
	
	const ALGO = PASSWORD_DEFAULT;
	
	const RETURN_WRONG_MASTER = 1; //mot de passe master faux
	const RETURN_WRONG_OLD = 2; //ancien mot de passe faux
	
	public function __construct(){
		$this->storedHash = file_get_contents($this->passFile);
		$this->masterStoredHash = file_get_contents($this->masterPassFile);
	}
	
	public function login($post){ //vérifie si le mot de pass est bon
		$pass = htmlentities($post['pass']);
		if(password_verify ($pass, $this->storedHash)){
			session_start();
			$_SESSION['logged'] = true; 
			return true;
		} 
		else return false;
	}
	
	public function checkUserLogged(){ //vérifie si l'utilisateur est déja connecté
		session_start();
		if(isset($_SESSION['logged']) && $_SESSION['logged']){
			return true;
		}else return false;
	}
	
	public function changePasswordWithMaster($newPass, $masterPass){
		if(!password_verify($masterPass, $this->masterStoredHash)){ //si le masterpass est faux
			return self::RETURN_WRONG_MASTER;
		}
		$this->storedHash = password_hash($newPass,self::ALGO); //on hash le pass
		file_put_contents($this->passFile, $this->storedHash); //on enregistre le hash du nouveau mot de passe
		
		return true;
	}
	public function changePassword($newPass, $oldPass){
		
		if(!password_verify($oldPass, $this->storedHash)){ //si l'ancien mot de passe est faux
			return self::RETURN_WRONG_OLD;
		}
		$this->storedHash = password_hash($newPass,self::ALGO); //on hash le pass
		file_put_contents($this->passFile, $this->storedHash); //on enregistre le hash du nouveau mot de passe
		
		return true;
	}
}