$(document).ready(function(){
	$('#config_save_new_pass').click(function(){
		updatePass();						
	});
	$('#config_save').click(function(){
		saveConfig();
	});
});

function checkPasswordValidity(pass){	
	if(pass.length < 12) return false; //retourne false si le pass a moins de 12 caractères
	if(!hasLowerCase(pass)) return false; //retour false si le pass n'a pas de minuscule
	if(!hasUpperCase(pass)) return false; //retourne false si le pass n'a pas de majuscule
	if(!hasDigit(pass)) return false; //retourne false si le pass n'a pas de chiffre
	
	return true //Si aucune erreur, le pass est bon on retourne true
}

function hasLowerCase(str) {
    return str.toUpperCase() != str;
}

function hasUpperCase(str) {
    return str.toLowerCase() != str;
}

function hasDigit(str) {
    return (/[0-9]/.test(str));
}

function updatePass(){
	var newPass = $('#config_new_pass').val();
	var newPassAgain = $('#config_new_pass_again').val();
	
	if(!checkPasswordValidity(newPass)){
		//mot de passe invalide
		alert('Votre mot de passe ne respecte pas les règles : 12 caractères minimum, Une majuscule minimum, Une minuscule minimum, Un chiffre minimum');
		return;
	}
	if(newPass.localeCompare(newPassAgain) != 0){
		//les mots de passes sont différents
		alert('Les deux nouveaux mots de passe sont différents');
		return;
	}
	 $.ajax({
	 	type: 'POST',
	 	data: {
	 		action: "updatePass",
			newPass: $('#config_new_pass').val(),
			oldPass: $('#config_old_pass').val(),
 		},
        url: 'ajax.php',

        // La fonction à apeller si la requête aboutie
        success: function (data) { 
        	console.log(data);
        	data = JSON.parse(data);
            if(data.status != 'ok') alert('Erreur lors du changement de mot de passe : phpErr');
            else {
            	$('#config_new_pass').val('');
            	$('#config_old_pass').val('');
            	$('#config_new_pass_again').val('');
            	alert('Mot de passe modifié');
            }
        },

        // La fonction à appeler si la requête n'a pas abouti
        error: function() {
        	alert('Erreur lors du changement de mot de passe : ajaxErr');
            console.log('erreur ajax');
        }

    });
}
function saveConfig(){
	var jingleSongValue = $('#config_jingles_gap').val();
	jingleSongValue = parseInt(jingleSongValue, 10);
	if(jingleSongValue > 5){
		alert("Nombre maximum de musique entre les jingles : 5");
		return null;
	}
	
	 $.ajax({
	 	type: 'POST',
	 	data: {
	 		action: "saveConfig",
			jingleGap: $('#config_jingles_gap').val(),
 		},
        url: 'ajax.php',

        // La fonction à apeller si la requête aboutie
        success: function (data) { 
        	console.log(data);           
            if(data != 'ok') alert('Erreur lors de l\'enregistrement : phpErr');
            else alert('Configuration enregistré');
        },

        // La fonction à appeler si la requête n'a pas abouti
        error: function() {
        	alert('Erreur lors de l\'enregistrement : ajaxErr');
            console.log('erreur ajax');
        }

    });
}