<?php

class Ratios{
	private static $instance;
	public $ratios = array();
	private $file = "ratios.rts";
	
	public static function getInstance(){
		if(Ratios::$instance == null) Ratios::$instance = new Ratios();
		return Ratios::$instance;
	}
	
	private function __construct(){
		
		if(file_exists($this->file)){
			$s = file_get_contents($this->file);
			$this->ratios = unserialize($s);
		}
	}
	
	public function getRatio($name){
		if(array_key_exists($name, $this->ratios)){
			return $this->ratios[$name];
		}else{
			return 0;
		}
	}
	
	public function setRatio($name,$ratio){
		$this->ratios[$name] = $ratio;
	}
	
	public function saveRatios()
	{
		$s = serialize($this->ratios);
		file_put_contents($this->file, $s);
	}
}
